'
' Classes used to model a kind of security zone implement this
' interface.
'
Friend Interface ISecurityZone
    '
    ' This method is called to notify this security zone of a
    ' change in a sensor measurement.
    '
    ' measurement - The new measurement
    ' mySensor - The object that models the sensor that produced the
    '            measurement.
    '
    Sub Notify(ByVal measurement As Integer, ByVal mySensor As Sensor)

    '
    ' This method is called by a child zone to report a fire.
    ' It is expected that the child zone has turned on
    ' sprinklers or taken other appropriate measures to control
    ' the fire within the child zone. The purpose of this method
    ' is to be overridden by other subclasses so that it can
    ' take any necessary actions outside of the child zone.
    '
    Sub FireAlarm(ByVal zone As SecurityZone)
End Interface 'ISecurityZone
